/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import cz.insophy.inplan.planning.ActivityChange;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;

public class ActivityChangeStack {
    private final List<ActivityChange> activityChangeList = new ArrayList<ActivityChange>();
    private final Deque<Integer> rollbackIndexStack = new ArrayDeque<Integer>();

    public void append(ActivityChange activityChange) {
        this.activityChangeList.add(activityChange);
    }

    public void append(List<ActivityChange> activityChanges) {
        this.activityChangeList.addAll(activityChanges);
    }

    public List<ActivityChange> getActivityChangeList() {
        return this.activityChangeList;
    }

    public void beginTransaction() {
        this.rollbackIndexStack.push(this.activityChangeList.size());
    }

    public void commit() {
        try {
            this.rollbackIndexStack.pop();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No transaction in progress.");
        }
    }

    public List<ActivityChange> rollback() {
        try {
            int rollbackTo = this.rollbackIndexStack.pop();
            ArrayList<ActivityChange> rollbackList = new ArrayList<ActivityChange>(this.activityChangeList.subList(rollbackTo, this.activityChangeList.size()));
            int n = this.activityChangeList.size() - rollbackTo;
            while (n-- > 0) {
                this.activityChangeList.remove(this.activityChangeList.size() - 1);
            }
            return rollbackList;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No transaction in progress.");
        }
    }

    public boolean isTransactionInProgress() {
        return !this.rollbackIndexStack.isEmpty();
    }

    public void clear() {
        if (this.isTransactionInProgress()) {
            throw new IllegalStateException("Transaction still in progress");
        }
        this.activityChangeList.clear();
        this.rollbackIndexStack.clear();
    }

    public int size() {
        return this.getActivityChangeList().size();
    }

    public ActivityChange get(int index) {
        return this.getActivityChangeList().get(index);
    }

    public void reduceStackSize(int toSize) {
        if (this.isTransactionInProgress()) {
            throw new IllegalStateException("Stack cannot be reduced while transaction in progress.");
        }
        int n = this.size() - toSize;
        while (n-- > 0) {
            this.getActivityChangeList().remove(this.size() - 1);
        }
    }
}

